//
//  OPDataProcessorMonitor.h
//  Image Downloader
//
//  Created by Nathan Van Fleet on 2015-06-02.
//  Copyright (c) 2015 Nathan Van Fleet. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OPDataMonitorProtocol.h"

@class OPDataController;

@interface OPDataControllerMonitor : NSObject <OPDataOperationMonitor, OPImageDataOperationMonitor>
@property (nonatomic, weak) OPDataController *controller;
@property (readonly, weak) id referenceObject;

// backgroundThreaded parameter determines if we dispatch to a background thread and then dispatch back to main queue on completion. If launched while off the main thread it will have to dispatch to the mainthread to execute.
+ (instancetype)monitorForModules:(NSArray *)modules identifier:(NSString *)identifier backgroundThreaded:(BOOL)inBackground completionBlock:(void(^)(id result, NSError *error))completionBlock;
+ (instancetype)monitorForModules:(NSArray *)modules identifier:(NSString *)identifier backgroundThreaded:(BOOL)inBackground progressBlock:(void(^)(float percentage, NSUInteger activeStep, NSUInteger stepCount))progressBlock completionBlock:(void(^)(id result, NSError *error))completionBlock ;

// Default - Executes modules in the background and completes on the main thread
// In general we want to do work on the background thread, unless there is a specifically tuned operation with modules that don't need a background thread or do work in another thread (and would otherwise hold up the main thread)
+ (instancetype)monitorForModules:(NSArray *)modules identifier:(NSString *)identifier completionBlock:(void(^)(id result, NSError *error))completionBlock;
+ (instancetype)monitorForModules:(NSArray *)modules identifier:(NSString *)identifier progressBlock:(void(^)(float percentage, NSUInteger activeStep, NSUInteger stepCount))progressBlock completionBlock:(void(^)(id result, NSError *error))completionBlock;

// Placeholder Image
- (OPImage *)placeholderImage;
@property (nonatomic, copy) OPImage *(^placeholderImageBlock)(void);
@end
